export async function showDirectoryPicker() {
    const dir = await window.showDirectoryPicker();

    // Track the dir in history.state
    const state = history.state || {};
    state.currentDir = dir;
    history.replaceState(state, '');

    return {
        name: dir.name,
        instance: DotNet.createJSObjectReference(dir)
    };
}

export async function reopenLastDirectory() {
    const value = history.state && history.state.currentDir;
    return value ? { name: value.name, instance: DotNet.createJSObjectReference(value) } : null;
}

export async function getFiles(directory) {
    // Build an array containing all the file entries
    const result = [];
    for await (const entry of directory.values())
        result.push(await entry.getFile());

    // For each entry, get name/size/modified
    return result.map(r => ({ name: r.name, size: r.size, lastModified: r.lastModifiedDate.toISOString() }));
}

export async function decodeAudioFile(name) {
    // Read the file
    history.state || {};
    const dir = history.state.currentDir;
    const fileHandle = await dir.getFileHandle(name);
    const file = await fileHandle.getFile();
    const fileBytes = await file.arrayBuffer();

    // Decode and extract the audio samples
    const audioBuffer = await new AudioContext().decodeAudioData(fileBytes);
    return new Uint8Array(audioBuffer.getChannelData(0).buffer);
}

export async function playAudioFile(name) {
    const samples = await decodeAudioFile(name);
    return playAudioData(samples);
}

async function getScriptFile(url, fileName) {
    try {
        const response = await fetch(url);
        const blob = await response.blob();

        // Create a new File object
        const file = new File([blob], fileName, { type: blob.type });
        return file;
    } catch (error) {
        throw new Error('Failed to fetch the script file.');
    }
}

export async function playAudioFile2(name) {
    var filePath = "audio/myaudio.mp3";
    var filePromise = await JSRuntime.InvokeAsync<IJSObjectReference>("getFileFromPath", filePath);

    //const samples = await decodeAudioFile(name);

    // Read the file
    //history.state || {};
    //const dir = history.state.currentDir;
    //const fileHandle = await dir.getFileHandle(name);
    //const file = await fileHandle.getFile();

    getScriptFile(url, fileName)
        .then((file) => {
            const fileBytes = await file.arrayBuffer();
            // Use the file here
            console.log(file);
        })
        .catch((error) => {
            console.error(error);
        });


    // Decode and extract the audio samples
    const audioBuffer = await new AudioContext().decodeAudioData(fileBytes);
    return new Uint8Array(audioBuffer.getChannelData(0).buffer);

    return playAudioData(samples);
}



export async function playAudioData(samples) {
    // Populate an AudioBuffer object
    const floatData = new Float32Array(samples.buffer);
    const audioContext = new AudioContext();
    const buffer = audioContext.createBuffer(/*numOfChannels*/ 1, floatData.length, /*sampleRate*/ 48000);
    buffer.copyToChannel(floatData, 0);

    // Start playing it
    const source = audioContext.createBufferSource();
    source.buffer = buffer;
    source.connect(audioContext.destination);
    source.start();
    return source;
}